/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: ConnectorDLL.cpp $
   Last Modification:
    $Author: MichaelT $
    $Modtime: $
    $Revision: 2363 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: no
     WinCE        : no
 
   Description:
    Connector DLL main entrypoint
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
     2         27.11.09    SS       Review
     1         04.06.2009  RM       created
 
**************************************************************************************/

/*****************************************************************************/
/*! \file ConnectorDLL.cpp                                                      
*   Connector DLL main entrypoint
/*****************************************************************************/

#include "stdafx.h"

/*****************************************************************************/
/*! \addtogroup netX_CONNECTOR_API netX Connector API implementation         */
/*! \{                                                                       */
/*****************************************************************************/

HANDLE g_hModule = NULL;

/*****************************************************************************/
/*! DLL entry point
*   \param  hModule     Module handle
*   \param  dwReason    Calling reason
*   \return TRUE always                                                      */
/*****************************************************************************/
BOOL APIENTRY DllMain(  HANDLE hModule,
                        DWORD dwReason,
                        LPVOID /*pvReserved*/)
{
  switch(dwReason)
  {
  case DLL_PROCESS_ATTACH:
    g_hModule = hModule;
    break;

  case DLL_PROCESS_DETACH:
    g_hModule = NULL;
    break;

  case DLL_THREAD_ATTACH:
  case DLL_THREAD_DETACH:
    break;

  }

  return TRUE;
}

/*****************************************************************************/
/*! \}                                                                       */
/*****************************************************************************/




